/*
 * Decompiled with CFR 0.152.
 */
package com.teamaurora.bayou_blues.common.world.gen.feature;

import com.google.common.collect.Sets;
import com.minecraftabnormals.abnormals_core.core.util.TreeUtil;
import com.mojang.serialization.Codec;
import com.teamaurora.bayou_blues.common.util.DirectionalBlockPos;
import com.teamaurora.bayou_blues.core.registry.BayouBluesBlocks;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.SaplingBlock;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.Feature;

public class CypressFeature
extends Feature<BaseTreeFeatureConfig> {
    public CypressFeature(Codec<BaseTreeFeatureConfig> config) {
        super(config);
    }

    public boolean generate(ISeedReader worldIn, ChunkGenerator generator, Random rand, BlockPos position, BaseTreeFeatureConfig config) {
        boolean bald;
        int height = rand.nextInt(5) + 9;
        boolean bl = bald = rand.nextInt(15) == 0;
        if (position.func_177956_o() <= 0 || position.func_177956_o() + height > worldIn.func_217301_I() - 1) {
            return false;
        }
        if (!TreeUtil.isValidGround((IWorld)worldIn, (BlockPos)position.func_177977_b(), (SaplingBlock)((SaplingBlock)BayouBluesBlocks.CYPRESS_SAPLING.get()))) {
            return false;
        }
        ArrayList<DirectionalBlockPos> logs = new ArrayList<DirectionalBlockPos>();
        ArrayList<BlockPos> leaves = new ArrayList<BlockPos>();
        for (int i = 0; i <= height; ++i) {
            logs.add(new DirectionalBlockPos(position.func_177981_b(i), Direction.UP));
        }
        int numBranches = rand.nextInt(4) + 1;
        if (numBranches == 4) {
            numBranches = 2;
        }
        for (int i = 0; i < numBranches; ++i) {
            Direction dir = Direction.func_176731_b((int)rand.nextInt(4));
            int x = bald ? rand.nextInt(height - 3) + 3 : rand.nextInt(height - 5) + 3;
            logs.add(new DirectionalBlockPos(position.func_177981_b(x).func_177972_a(dir), dir));
            logs.add(new DirectionalBlockPos(position.func_177981_b(x).func_177967_a(dir, 2), dir));
            this.disc2H(position.func_177981_b(x).func_177967_a(dir, 2), leaves, rand);
            this.disc1(position.func_177981_b(x + 1).func_177967_a(dir, 2), leaves);
        }
        if (!bald) {
            this.disc1(position.func_177981_b(height - 1), leaves);
            this.disc3H(position.func_177981_b(height), leaves, rand);
            this.disc2(position.func_177981_b(height + 1), leaves);
        }
        List<BlockPos> leavesClean = this.cleanLeavesArray(leaves, logs);
        boolean flag = true;
        for (DirectionalBlockPos log : logs) {
            if (TreeUtil.isAirOrLeaves((IWorldGenerationBaseReader)worldIn, (BlockPos)log.pos)) continue;
            flag = false;
        }
        if (!flag) {
            return false;
        }
        TreeUtil.setDirtAt((IWorld)worldIn, (BlockPos)position.func_177977_b());
        for (DirectionalBlockPos log : logs) {
            TreeUtil.placeDirectionalLogAt((IWorldWriter)worldIn, (BlockPos)log.pos, (Direction)log.direction, (Random)rand, (BaseTreeFeatureConfig)config);
        }
        for (BlockPos leaf : leavesClean) {
            TreeUtil.placeLeafAt((IWorldGenerationReader)worldIn, (BlockPos)leaf, (Random)rand, (BaseTreeFeatureConfig)config);
        }
        HashSet decSet = Sets.newHashSet();
        MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_78887_a();
        ArrayList<BlockPos> logsPos = new ArrayList<BlockPos>();
        for (DirectionalBlockPos log : logs) {
            logsPos.add(log.pos);
        }
        if (!config.field_227370_o_.isEmpty()) {
            logsPos.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            leavesClean.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            config.field_227370_o_.forEach(decorator -> decorator.func_225576_a_(worldIn, rand, logsPos, leavesClean, decSet, mutableBoundingBox));
        }
        return true;
    }

    private void disc1(BlockPos pos, List<BlockPos> leaves) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                if (Math.abs(x) == 1 && Math.abs(z) == 1) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void disc2(BlockPos pos, List<BlockPos> leaves) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
            }
        }
    }

    private void disc2H(BlockPos pos, List<BlockPos> leaves, Random rand) {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                if (Math.abs(x) == 2 && Math.abs(z) == 2) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
                if (rand.nextInt(3) != 0) continue;
                leaves.add(pos.func_177982_a(x, -1, z));
                if (rand.nextInt(3) != 0) continue;
                leaves.add(pos.func_177982_a(x, -2, z));
            }
        }
    }

    private void disc3H(BlockPos pos, List<BlockPos> leaves, Random rand) {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                if (Math.abs(x) == 3 && Math.abs(z) == 3) continue;
                leaves.add(pos.func_177982_a(x, 0, z));
                if (rand.nextInt(3) != 0) continue;
                leaves.add(pos.func_177982_a(x, -1, z));
                if (!rand.nextBoolean()) continue;
                leaves.add(pos.func_177982_a(x, -2, z));
            }
        }
    }

    private List<BlockPos> cleanLeavesArray(List<BlockPos> leaves, List<DirectionalBlockPos> logs) {
        ArrayList<BlockPos> logsPos = new ArrayList<BlockPos>();
        for (DirectionalBlockPos log : logs) {
            logsPos.add(log.pos);
        }
        ArrayList<BlockPos> newLeaves = new ArrayList<BlockPos>();
        for (BlockPos leaf : leaves) {
            if (logsPos.contains(leaf)) continue;
            newLeaves.add(leaf);
        }
        return newLeaves;
    }
}

